/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.potions;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class BetterBrewingRecipes {

    public static class ItemTagItemBrewingRecipe
    implements IBrewingRecipe {
        private final Item input;
        private final TagKey<Item> ingredient;
        private final ItemStack output;

        public ItemTagItemBrewingRecipe(Item input, TagKey<Item> ingredient, ItemStack output) {
            this.input = input;
            this.ingredient = ingredient;
            this.output = output;
        }

        public boolean isInput(ItemStack input) {
            return input.m_41720_() == this.input;
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.m_204117_(this.ingredient);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = new ItemStack((ItemLike)this.output.m_41720_());
            itemStack.m_41751_(new CompoundTag());
            return itemStack;
        }
    }

    public static class PotionTagItemBrewingRecipe
    implements IBrewingRecipe {
        private final Potion input;
        private final TagKey<Item> ingredient;
        private final ItemStack output;

        public PotionTagItemBrewingRecipe(Potion input, TagKey<Item> ingredient, ItemStack output) {
            this.input = input;
            this.ingredient = ingredient;
            this.output = output;
        }

        public boolean isInput(ItemStack input) {
            return PotionUtils.m_43579_((ItemStack)input) == this.input;
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.m_204117_(this.ingredient);
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = new ItemStack((ItemLike)this.output.m_41720_());
            itemStack.m_41751_(new CompoundTag());
            return itemStack;
        }
    }

    public static class PotionItemItemBrewingRecipe
    implements IBrewingRecipe {
        private final Potion input;
        private final Item ingredient;
        private final ItemStack output;

        public PotionItemItemBrewingRecipe(Potion input, Item ingredient, ItemStack output) {
            this.input = input;
            this.ingredient = ingredient;
            this.output = output;
        }

        public boolean isInput(ItemStack input) {
            return PotionUtils.m_43579_((ItemStack)input) == this.input;
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.m_41720_() == this.ingredient;
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = new ItemStack((ItemLike)this.output.m_41720_());
            itemStack.m_41751_(new CompoundTag());
            return itemStack;
        }
    }

    public static class PotionItemPotionBrewingRecipe
    implements IBrewingRecipe {
        private final Potion input;
        private final Item ingredient;
        private final Potion output;

        public PotionItemPotionBrewingRecipe(Potion input, Item ingredient, Potion output) {
            this.input = input;
            this.ingredient = ingredient;
            this.output = output;
        }

        public boolean isInput(ItemStack input) {
            return PotionUtils.m_43579_((ItemStack)input) == this.input;
        }

        public boolean isIngredient(ItemStack ingredient) {
            return ingredient.m_41720_() == this.ingredient;
        }

        public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
            if (!this.isInput(input) || !this.isIngredient(ingredient)) {
                return ItemStack.f_41583_;
            }
            ItemStack itemStack = new ItemStack((ItemLike)input.m_41720_());
            itemStack.m_41751_(new CompoundTag());
            PotionUtils.m_43549_((ItemStack)itemStack, (Potion)this.output);
            return itemStack;
        }
    }
}

